//
//  MedicalPackageCell.h
//  as350b3e
//
//  Created by Vadim Dagman on 4/3/14.
//
//

#import <UIKit/UIKit.h>
#import "MedicalPackageTVController.h"

@protocol MedicalPackageCellProtocol <NSObject>

- (void)cellDeleted:(UITableViewCell*)cell;
- (void)cellSizeChanged:(UITableViewCell*)cell;

@end

@class MedicalPackage;
@interface MedicalPackageCell : UITableViewCell<MedicalPackageControllerDelegate, UIAlertViewDelegate>

@property (weak, nonatomic) UIViewController* parentController;
@property (nonatomic) MedicalPackage* package;
@property __weak id<MedicalPackageCellProtocol> delegate;

- (CGFloat)cellHeightForPackage:(MedicalPackage*)package;

@end
